The following is a high-level diagram of what secure C2 infrastructure should look like - pioneered by [Tim MalcomVetter](https://twitter.com/malcomvetter), previously director of red teaming at Walmart.

![[6. Infrastructure Design.png]]

On the right, the victim network uses an encrypted protocol (HTTPS) to egress C2 traffic.  Cobalt Strike also AES encrypts the Beacon traffic before encapsulating it in HTTPS.  This means that P2P C2 traffic (over the SMB and TCP Beacons) is encrypted as well; and also means it's not the end of the world if you have to egress C2 over an unencrypted channel (e.g. if using something more exotic than HTTPS).

An SSH (or VPN) tunnel is setup from the C2 server to the HTTPS redirector.  It must be in this direction because:

1.  The simulated adversary area should have no direct inbound access from the Internet.
2.  You don't want keys or credentials for the C2 server on the redirector.

No data should be stored on the redirector, traffic should only transit through it.  Even though the redirector is (ostensibly) under your control, traffic should be kept safe from the cloud hosting provider themselves.  This allows the redirector to receive incoming traffic from the victim network and redirect it to the C2 server over the secure tunnel.

  Redirectors don't have to be VMs. CDNs, AWS Lambda, Azure Functions & CloudFlare Workers, and more can be used as "serverless" redirectors.

The adversary simulation area should be located on-premise of the red teaming company, access tightly controlled and audited.  The model above is simulated in Snap Labs using the following subnets and firewall rules.

![[7. Infrastructure Design.png]]


The victim network can only talk to the public zone over HTTPS on port 443.  The adversary zone can only talk to the public zone on port 22 for the SSH tunnel.  The public zone cannot initiate its own connections to either zone and the victim network cannot talk directly to the adversary zone.
